define(['angular', 'app', 'formatter'], function (angular, app) {
	"use strict";
	app.service('BaseCRUDMockService', function ($http, $q, $parse, $filter, formatter) {

		//Constructor
		var BaseCRUDService = function(config) {

			this.config = config;
			
			this.requests = {
				change : [],
				retrieve : []
			};

			this.mock = window.localStorage[config.dependency.linkTitles.GET] ? angular.fromJson(window.localStorage[config.dependency.linkTitles.GET]) : { collection : [], trackId : 0 };

			this.idGetter = $parse(this.config.object.uidKey);


		};

		//Methods
		BaseCRUDService.prototype = {};

		//Requires Override
		BaseCRUDService.prototype.transformRequest = function(item) {
			return this.config.object.requestTransform ? this.config.object.requestTransform(item) : item;
		};

		BaseCRUDService.prototype._makeRequest = function (httpConfig, linkTitle) {
			var that = this;
			var defer = $q.defer();

			function sendRequest(httpConfig) {

				var httpMock = function(config) {
					var defer = $q.defer();

					var item = config.data;

					switch(config.method) {
						case "GET" :
							var responseObj = {"objectType" : that.config.collection.objectType};
							responseObj[that.config.collection.name] = angular.copy(that.mock.collection);
							defer.resolve(responseObj) 
							break;
						case "PUT" :
							var expression = {};
							expression[that.config.object.uidKey] = config.url;
							var updateVal =  $filter("filter")(that.mock.collection, expression, true);
							that.mock.collection[that.mock.collection.indexOf(updateVal)[0]] = item;
							defer.resolve(angular.copy(item));
							break;
						case "POST" :
							item[that.config.object.uidKey] = (that.mock.trackId++).toString();
							item["objectType"] = "thing";
							item["link"] = [{rel: "self", href: item[that.config.object.uidKey]}];
							that.mock.collection.push(item);
							defer.resolve(angular.copy(item));
							break;
						case "DELETE" :
							var expression = {};
							expression[that.config.object.uidKey] = '!' + config.url;
							that.mock.collection = $filter("filter")(that.mock.collection, expression, true);
							defer.resolve("");
							break; 
					}

					window.localStorage[that.config.dependency.linkTitles.GET] = angular.toJson(that.mock) 

					return defer.promise;
				};

				if(httpConfig.method === "POST" || httpConfig.method === "PUT") {
					httpConfig.data = that.transformRequest(httpConfig.data);
				}

				var waitForIt = httpConfig.method === "GET" ? that.requests.change : that.requests.retrieve;

				$q.all(waitForIt).finally(function(){

					var request = httpMock(httpConfig).then(function (response) {
						defer.resolve(response);
					}, function (error) {
						defer.reject(error);
					}).finally(function(){
						waitForIt.splice(waitForIt.indexOf(request), 1);
					})

					if(httpConfig.method === "GET") {
						that.requests.retrieve.push(request);
					} else {
						that.requests.change.push(request);
					}

				});
			}


			sendRequest(httpConfig);

			return defer.promise;
		};

		//Requires Override
		BaseCRUDService.prototype.createEmpty = function() {
			return {};
		};

		BaseCRUDService.prototype.fetch = function (queryParams, preventLocalUpdate) {
			return this._makeRequest({method: "GET", params: queryParams});		
		};

		BaseCRUDService.prototype.save = function (item) {
			var method = !this.idGetter(item) || this.config.dependency.linkTitles.PUT === "none" ? "POST" : "PUT";
			return this._makeRequest({method: method, data: item, url : (method === "PUT" ? item.link[0].href : null)});
		};

		BaseCRUDService.prototype.delete = function (item) {
			if(this.idGetter(item)) {
				return this._makeRequest({method: "DELETE", url : item.link[0].href});
			} else {
				var defer = $q.defer();
				defer.reject();
				return defer.promise;
			}

		};

		return BaseCRUDService;
	});
});